require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative '../base/base'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'

class RequestAppointmentDetail < Base
  include PageObject

  def initialize(driver)
    super(driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @common = Common.new(@driver)
  end

  h2(:title, :css => '.primary-header h2')
  expected_title "Request Details"

  #status
  button(:cancel_btn, :id =>'cancel-request-btn')
  span(:status, :css=>'#request-status-group > p:nth-child(1) > span.request-status.field-contain.aside.aside-left')
  span(:status_last_updated, :css=>'.request-status-last-updated')
  p(:status_desc, :css=>'.request-status-desc')
  link(:video_appointment_link, :css=>'a[href="https://vet.mobilehealthdemo.com/video-appointment/"]')
  link(:provide_feedback_link, :css=>'a[href="#feedback"]')

  #request Details
  #div(:request_details_group, :css => '.request-details-group')
  div(:request_details_group, :css => '.request-details-section.modal-content-section:nth-of-type(1)')
  div(:communicate_with_clerk_group, :css=>'#request-appointment-messages .modal-content-section')

  #message
  h2(:message_header, :id =>'request-messages')
  p(:message_desc, :css=>'.request-messages-desc')
  label(:message_label, :css=>'#new-message-form label')
  textarea(:new_message, :id =>'new-message')
  p(:message_counter, :id =>'new-message-counter')
  div(:message_log, :id =>'request-message-log')
  button(:send_btn, :id =>'send-message-btn')

  elements(:messages_sent, :div, :css=>'.messages div.message-sent')
  div(:message_section, :css=>'.messages')
  div(:message_headers, :css=>'.messsages-header')
  elements(:messages_all, :p, :css=>'.messages p.message-text')

  link(:feedbackLink, :css=>'a[href="#feedback"]')


  def getNthFromMeMessage(nth)
    message = messages_sent_elements[nth - 1]
    splitMessage = message.text.split("\n")
    return splitMessage[2]
  end

  def getNthFromMeMeTimeStamp(nth)
    message = messages_sent_elements[nth - 1]
    splitMessage = message.text.split("\n")
    return splitMessage[1]
  end

  def clickBackButton
    button_element = @driver.button(:id => 'back-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    @common.waitWhileSpinnerPresent()
    @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
    sleep 2
  end

end

